import {TrainsSearchContextType} from 'reducers/trains/context/types';

import {ITrainsContextFromSearchUrlParams} from './getContextFromSearchUrlParams';

export default function checkDifferenceBetweenContextAndContextByUrlParams({
    searchContext,
    searchContextByUrlParams,
}: {
    searchContext: TrainsSearchContextType;
    searchContextByUrlParams: ITrainsContextFromSearchUrlParams;
}): boolean {
    if (
        !searchContext.from?.slug ||
        !searchContext.to?.slug ||
        !searchContext.when
    ) {
        return true;
    }

    return (
        searchContext.when !== searchContextByUrlParams.when ||
        searchContext.from.slug !== searchContextByUrlParams.from.slug ||
        searchContext.to.slug !== searchContextByUrlParams.to.slug
    );
}
