import {
    ESearchErrorTypes,
    SamePointsSearchError,
} from 'projects/trains/lib/search/constants';

import {TrainsSearchContextType} from 'reducers/trains/context/types';

export const checkContextSamePointsError = (
    searchContext: TrainsSearchContextType,
): void => {
    const hasSamePointsError = searchContext.errors?.some(
        error => error.type === ESearchErrorTypes.SAME_POINTS,
    );

    if (hasSamePointsError) {
        throw new SamePointsSearchError();
    }
};
