import {TTrainsSegmentId} from 'types/trains/common/segment/ITrainsSegment';
import {ITrainsOrderLocation} from 'types/trains/booking/ITrainsOrderLocation';

interface ITrainsContextFromOrderUrlParams {
    from: {
        title?: string;
        key?: string;
    };
    to: {
        title?: string;
        key?: string;
    };
    when?: string;
    originalWhen?: string;
    returnWhen?: string;
    forwardSegmentId?: TTrainsSegmentId;
}

/**
 * Вернёт жд контекст из параметров урла на странице жд покупки
 *
 * @param query - параметры запроса
 */
export default function getContextFromOrderUrlParams(
    query: ITrainsOrderLocation,
): ITrainsContextFromOrderUrlParams {
    return {
        from: {
            title: query.fromName,
            key: query.fromId,
        },
        to: {
            title: query.toName,
            key: query.toId,
        },
        when: query.when,
        originalWhen: query.when,
        returnWhen: query.returnWhen,
        forwardSegmentId: query.forwardSegmentId,
    };
}
