import moment, {Moment} from 'moment-timezone';

import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {EDirection} from 'types/common/EDirection';

export default function getNextSearchDayMoment(
    context: ITrainsFilledSearchContext,
): Moment {
    const isForward = context.direction === EDirection.FORWARD;

    const searchDate = isForward ? context.when : context.returnWhen;
    const searchTimezone = isForward
        ? context.from.timezone
        : context.to.timezone;

    return moment.tz(searchDate, searchTimezone).add(1, 'day');
}
