import moment, {Moment} from 'moment';

import {WHEN_SPECIAL_VALUE, WhenType} from 'types/common/When';

import {getNow} from 'utilities/dateUtils';

/**
 * Является ли дата специальным значением.
 *
 * @param {WhenType} when - Дата отправления.
 *
 * @return {boolean}
 */
export function isWhenSpecialValue(when: WhenType): when is WHEN_SPECIAL_VALUE {
    return (
        when === WHEN_SPECIAL_VALUE.TODAY ||
        when === WHEN_SPECIAL_VALUE.TOMORROW ||
        when === WHEN_SPECIAL_VALUE.AFTER_TOMORROW ||
        when === WHEN_SPECIAL_VALUE.ALL_DAYS
    );
}

export function getDateFromSpecialValue(
    when: WHEN_SPECIAL_VALUE,
): Moment | void {
    if (when === WHEN_SPECIAL_VALUE.TODAY) {
        return moment(getNow());
    } else if (when === WHEN_SPECIAL_VALUE.TOMORROW) {
        return moment(getNow()).add(1, 'days');
    } else if (when === WHEN_SPECIAL_VALUE.AFTER_TOMORROW) {
        return moment(getNow()).add(2, 'days');
    }

    return;
}
