import {
    ITrainsFilledSearchContext,
    ITrainsSearchApiContext,
} from 'reducers/trains/context/types';

/**
 * Дополняем поисковый жд контекст необходимыми данными из результатов поиска
 *
 * @param formContext - контекст полученный из поисковой формы
 * @param searchContext - контекст полученный из ответа ручки бекенда
 */
export default function updateContext(
    formContext: ITrainsFilledSearchContext,
    searchContext: ITrainsSearchApiContext,
): ITrainsFilledSearchContext {
    const {search, original, isChanged, latestDatetime} = searchContext;

    const updatedContext = {
        ...formContext,
        latestDatetime,
    };

    if (!isChanged) {
        return updatedContext;
    }

    // Данные о исходном контексте хранятся для построения дисклеймеров сужения/расширения
    return {
        ...updatedContext,
        isChanged: true,
        from: {
            ...updatedContext.from,
            ...search.pointFrom,
        },
        to: {
            ...updatedContext.to,
            ...search.pointTo,
        },
        original,
    };
}
