import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import {TrainsTariffCategoryCode} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

const mapPassengerTypeToTariffType: Record<
    PASSENGERS_TYPES,
    TrainsTariffCategoryCode
> = {
    [PASSENGERS_TYPES.CHILDREN]: TrainsTariffCategoryCode.CHILD,
    [PASSENGERS_TYPES.ADULTS]: TrainsTariffCategoryCode.FULL,
    [PASSENGERS_TYPES.BABIES]: TrainsTariffCategoryCode.BABY,
};

const mapTariffTypeToPassengerType: Record<
    TrainsTariffCategoryCode,
    PASSENGERS_TYPES
> = {
    [TrainsTariffCategoryCode.CHILD]: PASSENGERS_TYPES.CHILDREN,
    [TrainsTariffCategoryCode.FULL]: PASSENGERS_TYPES.ADULTS,
    [TrainsTariffCategoryCode.BABY]: PASSENGERS_TYPES.BABIES,
};

export function convertPassengerTypeToTariffType(
    passengerType: PASSENGERS_TYPES,
): TrainsTariffCategoryCode {
    return mapPassengerTypeToTariffType[passengerType];
}

export function convertTariffTypeToPassengerType(
    tariffType: TrainsTariffCategoryCode,
): PASSENGERS_TYPES {
    return mapTariffTypeToPassengerType[tariffType];
}
