import moment from 'moment-timezone';

import {DateLikeType, isValidDate} from 'utilities/dateUtils';

export const checkTrainsInvalidReturnWhen = (
    when?: DateLikeType | null,
    returnWhen?: DateLikeType | null,
): boolean => {
    if (!when || !returnWhen) {
        return false;
    }

    if (!isValidDate(returnWhen)) {
        return true;
    }

    return moment(returnWhen).isBefore(when);
};
