import moment from 'moment';

export enum ETimeUnit {
    MINUTES = 'minutes',
    HOURS = 'hours',
    DAYS = 'days',
    WEEKS = 'weeks',
}

export const TIME_UNITS_LIST = [
    ETimeUnit.MINUTES,
    ETimeUnit.HOURS,
    ETimeUnit.DAYS,
    ETimeUnit.WEEKS,
];
export const TIME_UNITS_LENGTHS = TIME_UNITS_LIST.reduce(
    (result, unit) => ({
        ...result,
        [unit]: moment.duration(1, unit).asMilliseconds(),
    }),
    {} as Record<ETimeUnit, number>,
);

export enum EShorteningOption {
    AUTO = 'auto',
    NEVER = 'never',
    ALWAYS = 'always',
}
