import {ETimeUnit} from 'projects/trains/lib/date/duration/constants';

import * as i18n from 'i18n/common-formatDuration';

type TUnitTranslateKey = (params: {count: number}) => string;

const mapUnitToFullTranslateKey: Record<ETimeUnit, TUnitTranslateKey> = {
    [ETimeUnit.MINUTES]: i18n.minutes,
    [ETimeUnit.HOURS]: i18n.hours,
    [ETimeUnit.DAYS]: i18n.days,
    [ETimeUnit.WEEKS]: i18n.weeks,
};

const mapUnitToShortTranslateKey: Record<ETimeUnit, TUnitTranslateKey> = {
    [ETimeUnit.MINUTES]: i18n.minutesShort,
    [ETimeUnit.HOURS]: i18n.hoursShort,
    [ETimeUnit.DAYS]: i18n.daysShort,
    [ETimeUnit.WEEKS]: i18n.weeksShort,
};

export default function getUnitText(
    count: number,
    unit: ETimeUnit,
    isShort: boolean,
): string {
    const dict = isShort
        ? mapUnitToShortTranslateKey
        : mapUnitToFullTranslateKey;

    return dict[unit]({count});
}
