import moment from 'moment';

import {DateLikeType, getNow, humanFormatDate} from 'utilities/dateUtils';

import * as i18nBlock from 'i18n/trains-whenSpecialValues';

/*
 * Возвращает понятную для человека дату со специальными значениями "Сегодня" и "Завтра"
 */
export default function getHumanDateWithSpecialValues(
    date: DateLikeType,
): string {
    const now = moment(getNow());

    if (now.isSame(date, 'day')) {
        return i18nBlock.today();
    }

    if (moment(now).add(1, 'd').isSame(date, 'day')) {
        return i18nBlock.tomorrow();
    }

    if (moment(now).add(2, 'd').isSame(date, 'day')) {
        return i18nBlock.afterDashTomorrow();
    }

    return humanFormatDate(date);
}
