import humanizePeriod, {humanizeDate} from 'utilities/dateUtils/humanizePeriod';

export const getTrainsHumanizeDatesLabel = ({
    startDate,
    endDate,
}: {
    startDate?: string | null;
    endDate?: string | null;
}): string | undefined => {
    if (!startDate) {
        return undefined;
    }

    if (!endDate) {
        return humanizeDate(startDate);
    }

    return humanizePeriod(startDate, endDate, {
        short: true,
        checkSameDate: false,
        checkAnotherEndYear: false,
    });
};
