import moment from 'moment-timezone';

export default function isSameISODateString(
    dateA: string,
    dateB: string,
): boolean {
    const momentA = moment.tz(dateA, moment.ISO_8601, 'UTC');

    if (!momentA.isValid()) {
        return false;
    }

    const momentB = moment.tz(dateB, moment.ISO_8601, 'UTC');

    if (!momentB.isValid()) {
        return false;
    }

    return momentA.valueOf() === momentB.valueOf();
}
