import moment from 'moment-timezone';

import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import isTrainsWhenSearch from 'projects/trains/lib/date/isTrainsWhenSearch';
import {isWhenSpecialValue} from 'projects/trains/lib/context';
import {getNow} from 'utilities/dateUtils';

/**
 * Функция проверяет является ли дата поиска жд прошедшей или не валидной.
 */
export default function isTrainsOutdatedOrWrongWhen(
    when: string | WHEN_SPECIAL_VALUE,
    timezone?: Nullable<string>,
): boolean {
    if (isWhenSpecialValue(when)) {
        return false;
    }

    if (!isTrainsWhenSearch(when)) {
        return true;
    }

    const nowMoment = timezone
        ? moment.tz(getNow(), timezone)
        : moment(getNow());
    const whenMoment = timezone ? moment.tz(when, timezone) : moment(when);

    return whenMoment.isBefore(nowMoment, 'day');
}
