import moment from 'moment';

import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import {isWhenSpecialValue} from 'projects/trains/lib/context';

export default function isTrainsWhenSearch(
    whenInStr: string | WHEN_SPECIAL_VALUE,
) {
    if (isWhenSpecialValue(whenInStr)) {
        return [
            WHEN_SPECIAL_VALUE.AFTER_TOMORROW,
            WHEN_SPECIAL_VALUE.TOMORROW,
            WHEN_SPECIAL_VALUE.TODAY,
        ].includes(whenInStr);
    }

    const whenInDate = moment(whenInStr);

    return whenInDate.isValid();
}
