import moment, {Moment} from 'moment-timezone';

import {getNow} from 'utilities/dateUtils';

export const getToday = (timezone: string): Moment =>
    moment.tz(getNow(), timezone).startOf('day');

export function isSameTime(timeA: Moment, timeB: Moment): boolean {
    return (
        timeA.hours() === timeB.hours() && timeA.minutes() === timeB.minutes()
    );
}

/**
 * Вернёт дату со временем установленным на начало дня
 * Нормальные люди используют startOfDay, но при использовании таймзон и вычислений с ним возникают проблемы:
 * https://github.com/moment/moment/issues/3774
 *
 * @param momentDate - moment объект
 */
export function getStartOfDate(momentDate: Moment): Moment {
    return momentDate.clone().hours(0).minutes(0).seconds(0).milliseconds(0);
}
