import {
    COUNTRY_CODE_BY,
    COUNTRY_CODE_KZ,
    COUNTRY_CODE_RU,
    COUNTRY_CODE_UA,
    COUNTRY_CODE_UZ,
} from 'projects/trains/constants/countries';

import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';

const COUNTRIES_WITCH_FULL_SCHEDULE = [
    COUNTRY_CODE_RU,
    COUNTRY_CODE_BY,
    COUNTRY_CODE_UA,
    COUNTRY_CODE_KZ,
    COUNTRY_CODE_UZ,
];

/**
 * Возможная неполнота поискового ответа.
 * Полное расписание есть только для определенных стран.
 * Если поиск происходит за пределами этих стран, то есть вероятность неполноты поиска.
 *
 * @param context - поисковый контекст.
 */
export default function isIncompleteScheduleDisclaimerAvailable(
    context: ITrainsFilledSearchContext,
): boolean {
    const {from, to} = context;
    const countryFrom = from && from.country && from.country.code;
    const countryTo = to && to.country && to.country.code;

    return (
        !COUNTRIES_WITCH_FULL_SCHEDULE.includes(countryFrom) &&
        !COUNTRIES_WITCH_FULL_SCHEDULE.includes(countryTo)
    );
}
