import {
    ETrainsFilterType,
    ITrainsFilters,
} from 'types/trains/search/filters/ITrainsFilters';

/**
 * Проверяет соответсвует ли данный сегмент условиям фильтра
 *
 * @param segmentIndex
 * @param filtersData - состояние фильтров
 * @param [excludeFilterType] - тип фильтра, который не нужно учитывать
 */
export default function applyFilters({
    segmentIndex,
    filtersData,
    excludeFilterType,
}: {
    segmentIndex: number;
    filtersData: ITrainsFilters;
    excludeFilterType?: ETrainsFilterType;
}): boolean {
    return Object.keys(filtersData)
        .filter(filterType => filterType !== excludeFilterType)
        .every(
            filterType =>
                filtersData[filterType as ETrainsFilterType]
                    .filteredSegmentIndices[segmentIndex],
        );
}
