import intersection from 'lodash/intersection';

import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {ITrainsFilters} from 'types/trains/search/filters/ITrainsFilters';
import {ITrainsTariffApiSegment} from 'server/api/TrainsApi/types/ITrainsGetTariffsApi/models';

import priceRange from 'projects/trains/lib/filters/managers/priceRange';

/**
 * Возвращает список тарифов для отображения подходящих под фильтр priceRange.
 */
export default function filterTariffClassKeysByPriceRange(
    tariffClassKeys: TRAIN_COACH_TYPE[],
    segment: ITrainsTariffApiSegment,
    filters: ITrainsFilters,
): TRAIN_COACH_TYPE[] {
    if (tariffClassKeys.length === 0) {
        return tariffClassKeys;
    }

    const filteredTrainTariffClassesByPriceRange =
        filters?.priceRange?.value &&
        priceRange.getSuitableSegmentTariffClasses(
            filters.priceRange.value,
            segment,
        );

    if (
        filteredTrainTariffClassesByPriceRange &&
        filteredTrainTariffClassesByPriceRange.length > 0
    ) {
        return intersection(
            tariffClassKeys,
            filteredTrainTariffClassesByPriceRange,
        );
    }

    return tariffClassKeys;
}
