import intersection from 'lodash/intersection';

import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {ITrainsFilters} from 'types/trains/search/filters/ITrainsFilters';

/**
 * Возвращает список тарифов для отображения подходящих под фильтр trainTariffClass
 */
export default function filterTariffClassKeysByTrainTariffClass(
    tariffClassKeys: TRAIN_COACH_TYPE[],
    filters: ITrainsFilters,
): TRAIN_COACH_TYPE[] {
    if (tariffClassKeys.length === 0) {
        return tariffClassKeys;
    }

    const filteredTrainTariffClasses = filters?.trainTariffClass?.value;

    if (filteredTrainTariffClasses && filteredTrainTariffClasses.length) {
        return intersection(tariffClassKeys, filteredTrainTariffClasses);
    }

    return tariffClassKeys;
}
