import {
    ETrainsFilterType,
    TTrainsFilter,
} from 'types/trains/search/filters/ITrainsFilters';

/**
 * Проверяет активен ли фильтр
 * @param filter
 */
export default function getFilterIsActive(filter: TTrainsFilter): boolean {
    if (filter.type === ETrainsFilterType.PRICE_RANGE) {
        const min = filter.activeOptions[0]?.min ?? 0;
        const max =
            filter.activeOptions[filter.activeOptions.length - 1]?.max ??
            Infinity;

        const selectedValue = filter.value[0];

        return Boolean(
            selectedValue &&
                (min !== selectedValue.min || max !== selectedValue.max),
        );
    }

    if (filter.type === ETrainsFilterType.HIDE_WITHOUT_PRICE) {
        return filter.value;
    }

    return Boolean(filter.value.length);
}
