import {TTrainsFilterManagers} from 'types/trains/search/filters/ITrainsFilters';

import priceRange from 'projects/trains/lib/filters/managers/priceRange';
import hideWithoutPrice from 'projects/trains/lib/filters/managers/hideWithoutPrice';
import trainTariffClass from 'projects/trains/lib/filters/managers/trainTariffClass';
import highSpeedTrain from 'projects/trains/lib/filters/managers/highSpeedTrain';
import arrival from 'projects/trains/lib/filters/managers/arrival';
import departure from 'projects/trains/lib/filters/managers/departure';
import stationFrom from 'projects/trains/lib/filters/managers/stationFrom';
import stationTo from 'projects/trains/lib/filters/managers/stationTo';

export default function getFilterManagers(): TTrainsFilterManagers {
    return [
        priceRange,
        hideWithoutPrice,
        trainTariffClass,
        highSpeedTrain,
        arrival,
        departure,
        stationFrom,
        stationTo,
    ];
}
