import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {
    ETrainsFilterType,
    ITrainsFilters,
} from 'types/trains/search/filters/ITrainsFilters';
import {ETimeOfDay} from 'utilities/dateUtils/types';

import arrival from 'projects/trains/lib/filters/managers/arrival';
import departure from 'projects/trains/lib/filters/managers/departure';
import hideWithoutPrice from 'projects/trains/lib/filters/managers/hideWithoutPrice';
import highSpeedTrain from 'projects/trains/lib/filters/managers/highSpeedTrain';
import priceRange from 'projects/trains/lib/filters/managers/priceRange';
import stationFrom from 'projects/trains/lib/filters/managers/stationFrom';
import stationTo from 'projects/trains/lib/filters/managers/stationTo';
import trainTariffClass from 'projects/trains/lib/filters/managers/trainTariffClass';

export interface ITrainsFilterQuery {
    arrival?: ETimeOfDay[];
    departure?: ETimeOfDay[];
    seats?: 'y';
    highSpeedTrain?: string[];
    priceRange?: string[];
    stationFrom?: string[];
    stationTo?: string[];
    trainTariffClass?: TRAIN_COACH_TYPE[];
}

export default function getFiltersQuery(
    filters?: ITrainsFilters | null,
): ITrainsFilterQuery {
    if (!filters) {
        return {};
    }

    return {
        ...arrival.serializeToQuery(filters[ETrainsFilterType.ARRIVAL].value),
        ...departure.serializeToQuery(
            filters[ETrainsFilterType.DEPARTURE].value,
        ),
        ...hideWithoutPrice.serializeToQuery(
            filters[ETrainsFilterType.HIDE_WITHOUT_PRICE].value,
        ),
        ...highSpeedTrain.serializeToQuery(
            filters[ETrainsFilterType.HIGH_SPEED_TRAIN].value,
        ),
        ...priceRange.serializeToQuery(
            filters[ETrainsFilterType.PRICE_RANGE].value,
        ),
        ...stationFrom.serializeToQuery(
            filters[ETrainsFilterType.STATION_FROM].value,
        ),
        ...stationTo.serializeToQuery(
            filters[ETrainsFilterType.STATION_TO].value,
        ),
        ...trainTariffClass.serializeToQuery(
            filters[ETrainsFilterType.TRAIN_TARIFF_CLASS].value,
        ),
    };
}
