import upperFirst from 'lodash/upperFirst';

import {ITrainGenericService} from 'server/api/GenericOrderApi/types/common/TGenericService';

import {TrainsOrderStateInterface} from 'reducers/trains/order/reducer';

import {humanList} from 'utilities/strings/humanList';
import {getActualPlaces} from 'projects/trains/lib/order/places';
import getCoachTypeText from 'projects/trains/lib/getCoachTypeText';

import * as i18nTrainsCoachPropertiesBlock from 'i18n/trains-coach-properties';
import * as i18nTrainsOrderTicketsBlock from 'i18n/trains-order-tickets';

export default function formatPlacesInfo(
    trainService: ITrainGenericService,
    order: TrainsOrderStateInterface,
): string {
    const {direction, segmentIndex, carType, carNumber, passengers} =
        trainService.trainInfo;
    const coach = order.trains[direction][segmentIndex]?.coach;

    const placeNumbers = getActualPlaces(passengers);

    const placesContent: string[] = [];

    if (coach?.throughArrival) {
        placesContent.push(i18nTrainsCoachPropertiesBlock.throughDashCoach());
    }

    placesContent.push(
        getCoachTypeText(carType),
        i18nTrainsOrderTicketsBlock.coachDashNumber({
            number: parseInt(carNumber, 10),
        }),
    );

    if (placeNumbers.length > 0) {
        placesContent.push(
            i18nTrainsOrderTicketsBlock.placeDashNumber({
                numbers: humanList(placeNumbers),
            }),
        );
    }

    return upperFirst(placesContent.join(', '));
}
