import {ITrainsFilters} from 'types/trains/search/filters/ITrainsFilters';
import {TTrainsFilterTypeAndValue} from 'types/trains/search/filters/TTrainsFilterTypeAndValue';

import {getActiveFilterManagerTypes} from 'projects/trains/lib/genericSearch/filters/managers/getActiveFilterManagerTypes';
import {getFilterManagerByType} from 'projects/trains/lib/genericSearch/filters/managers/getFilterManagerByType';
import {getTrainsFilterIntentLabelByType} from 'projects/trains/lib/genericSearch/filters/getTrainsFilterIntentLabelByType';

export interface IFilterWithTextAndDefaultValue {
    text: string;
    valueAndType: TTrainsFilterTypeAndValue;
}

/*
 * Возвращает список активных фильтров с заголовоком, типом и дефолтным значением
 * */

export const getActiveFiltersWithTextAndValue = ({
    filters,
}: {
    filters: ITrainsFilters | null;
}): IFilterWithTextAndDefaultValue[] => {
    const activeFilterManagerTypes = getActiveFilterManagerTypes({filters});

    return activeFilterManagerTypes.map<IFilterWithTextAndDefaultValue>(
        (managerType): IFilterWithTextAndDefaultValue => {
            const filterManager = getFilterManagerByType(managerType);

            return {
                text: getTrainsFilterIntentLabelByType(filterManager.type),
                valueAndType: {
                    type: filterManager.type,
                    value: filterManager.getDefaultValue(),
                } as TTrainsFilterTypeAndValue,
            };
        },
    );
};
