import {ITrainsFilters} from 'types/trains/search/filters/ITrainsFilters';

import {TRAINS_FILTER_MANAGER_TYPES} from './managers/index';
import {getFilterManagerByType} from './managers/getFilterManagerByType';

/*
 * Получаем фильтры со сброшенными к дефолтным значениями
 * */

export const getFiltersWithDefaultValues = ({
    filters,
}: {
    filters: ITrainsFilters | null;
}): ITrainsFilters | null => {
    if (!filters) {
        return null;
    }

    return TRAINS_FILTER_MANAGER_TYPES.reduce<ITrainsFilters>(
        (resultFilters, type) => {
            const filterManager = getFilterManagerByType(type);
            const filter = filters[type];

            resultFilters[type] = {
                ...filter,
                // @ts-ignore trains "any" type for filterManager + filter
                value: filterManager.getDefaultValue() as any,
            };

            return resultFilters;
        },
        {} as ITrainsFilters,
    );
};
