import {ETrainsFilterType} from 'types/trains/search/filters/ITrainsFilters';

import * as i18nCommonFiltersBlock from 'i18n/common-filters';
import * as i18nTrainsFiltersBlock from 'i18n/trains-filters';

/*
 * Заголовок фильтра на основе его типа
 * */

export const getTrainsFilterIntentLabelByType = (
    filterType: ETrainsFilterType,
): string => {
    switch (filterType) {
        case ETrainsFilterType.ARRIVAL: {
            return i18nCommonFiltersBlock.arrival();
        }

        case ETrainsFilterType.DEPARTURE: {
            return i18nCommonFiltersBlock.departure();
        }

        case ETrainsFilterType.HIDE_WITHOUT_PRICE: {
            return i18nTrainsFiltersBlock.titleDashPricePresence();
        }

        case ETrainsFilterType.TRAIN_TARIFF_CLASS: {
            return i18nTrainsFiltersBlock.titleDashTrainTariffClass();
        }

        case ETrainsFilterType.STATION_TO: {
            return i18nTrainsFiltersBlock.titleDashStationTo();
        }

        case ETrainsFilterType.STATION_FROM: {
            return i18nTrainsFiltersBlock.titleDashStationFrom();
        }

        case ETrainsFilterType.HIGH_SPEED_TRAIN: {
            return i18nTrainsFiltersBlock.titleDashHighSpeedTrain();
        }

        case ETrainsFilterType.PRICE_RANGE: {
            return i18nTrainsFiltersBlock.titleDashPriceRange();
        }
    }
};
