import {TrainsSearchContextType} from 'reducers/trains/context/types';
import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';
import {ITrainsFilters} from 'types/trains/search/filters/ITrainsFilters';
import {EQueryingStatus} from 'types/trains/search/searchInfo/ITrainsSearchInfo';

import {getQueryByBrowserHistory} from 'utilities/getQueryByBrowserHistory/getQueryByBrowserHistory';

import {TRAINS_FILTER_MANAGER_TYPES} from './managers/index';
import {getFilterManagerByType} from './managers/getFilterManagerByType';

/*
 * Рассчитываем элементы в группах и значения для фильтров на основе variants и query после каждой итерации поллинга
 * */

export const getTrainsFiltersByVariants = ({
    status,
    variants,
    context,
}: {
    status: EQueryingStatus;
    variants: ITrainsVariant[];
    context: TrainsSearchContextType;
}): ITrainsFilters => {
    const query = getQueryByBrowserHistory();

    return TRAINS_FILTER_MANAGER_TYPES.reduce<ITrainsFilters>(
        (filters, type) => {
            const filterManager = getFilterManagerByType(type);

            // @ts-ignore trains "any" type for filterManager + filter
            filters[type] = filterManager.getFilterByVariantsAndQuery({
                query,
                status,
                variants,
                context,
            });

            return filters;
        },
        {} as ITrainsFilters,
    );
};
