import {ITrainsFilters} from 'types/trains/search/filters/ITrainsFilters';

import {
    TTrainsFilterManagerTypes,
    TRAINS_FILTER_MANAGER_TYPES,
} from 'projects/trains/lib/genericSearch/filters/managers/index';
import {getFilterManagerByType} from 'projects/trains/lib/genericSearch/filters/managers/getFilterManagerByType';

export const getActiveFilterManagerTypes = ({
    filters,
}: {
    filters: ITrainsFilters | null;
}): TTrainsFilterManagerTypes => {
    if (!filters) {
        return [];
    }

    return TRAINS_FILTER_MANAGER_TYPES.filter(type => {
        const filterManager = getFilterManagerByType(type);
        const filterInfo = filters[type];

        if (!filterManager) {
            return false;
        }

        // trains "any" type for filterManager + filter
        return filterManager.checkActiveValue(filterInfo.value as any);
    });
};
