import {ETrainsFilterType} from 'types/trains/search/filters/ITrainsFilters';

import PriceRangeFilterManager from './priceRange/priceRangeFilterManager';
import ArrivalFilterManager from './arrival/arrivalFilterManager';
import DepartureFilterManager from './departure/departureFilterManager';
import HighSpeedTrainFilterManager from './highSpeedTrain/highSpeedTrainFilterManager';
import HideWithoutPriceFilterManager from './hideWithoutPrice/hideWithoutPriceFilterManager';
import StationFromFilterManager from './stationFrom/stationFromFilterManager';
import StationToFilterManager from './stationTo/stationToFilterManager';
import TrainTariffClassFilterManager from './trainTariffClass/trainTariffClassFilterManager';

export type TTrainsFilterManagerTypes = (keyof ITrainsFilterManagersByType)[];

const priceRangeFilterManager = new PriceRangeFilterManager();
const arrivalFilterManager = new ArrivalFilterManager();
const departureFilterManager = new DepartureFilterManager();
const highSpeedTrainFilterManager = new HighSpeedTrainFilterManager();
const hideWithoutPriceFilterManager = new HideWithoutPriceFilterManager();
const stationFromFilterManager = new StationFromFilterManager();
const stationToFilterManager = new StationToFilterManager();
const trainTariffClassFilterManager = new TrainTariffClassFilterManager();

export interface ITrainsFilterManagersByType {
    [ETrainsFilterType.ARRIVAL]: ArrivalFilterManager;
    [ETrainsFilterType.DEPARTURE]: DepartureFilterManager;
    [ETrainsFilterType.PRICE_RANGE]: PriceRangeFilterManager;
    [ETrainsFilterType.HIGH_SPEED_TRAIN]: HighSpeedTrainFilterManager;
    [ETrainsFilterType.HIDE_WITHOUT_PRICE]: HideWithoutPriceFilterManager;
    [ETrainsFilterType.STATION_FROM]: StationFromFilterManager;
    [ETrainsFilterType.STATION_TO]: StationToFilterManager;
    [ETrainsFilterType.TRAIN_TARIFF_CLASS]: TrainTariffClassFilterManager;
}

export const TRAINS_FILTER_MANAGERS_BY_TYPE: ITrainsFilterManagersByType = {
    [ETrainsFilterType.ARRIVAL]: arrivalFilterManager,
    [ETrainsFilterType.DEPARTURE]: departureFilterManager,
    [ETrainsFilterType.PRICE_RANGE]: priceRangeFilterManager,
    [ETrainsFilterType.HIGH_SPEED_TRAIN]: highSpeedTrainFilterManager,
    [ETrainsFilterType.HIDE_WITHOUT_PRICE]: hideWithoutPriceFilterManager,
    [ETrainsFilterType.STATION_FROM]: stationFromFilterManager,
    [ETrainsFilterType.STATION_TO]: stationToFilterManager,
    [ETrainsFilterType.TRAIN_TARIFF_CLASS]: trainTariffClassFilterManager,
};

// Right order: TRAIN_TARIFF_CLASS -> PRICE_RANGE -> ... ->
export const TRAINS_FILTER_MANAGER_TYPES: TTrainsFilterManagerTypes = [
    ETrainsFilterType.TRAIN_TARIFF_CLASS,
    ETrainsFilterType.PRICE_RANGE,
    ETrainsFilterType.ARRIVAL,
    ETrainsFilterType.DEPARTURE,
    ETrainsFilterType.HIGH_SPEED_TRAIN,
    ETrainsFilterType.HIDE_WITHOUT_PRICE,
    ETrainsFilterType.STATION_FROM,
    ETrainsFilterType.STATION_TO,
];
