import {TTrainsFilterTypeAndValue} from 'types/trains/search/filters/TTrainsFilterTypeAndValue';
import {TTrainsFilter} from 'types/trains/search/filters/ITrainsFilters';

import {getFilterManagerByType} from './managers/getFilterManagerByType';

/*
 * Перед применением и сохранением значения фильтра необходима подготовка значения
 */
export const prepareTrainsFilterValueBeforeSaveToState = ({
    filter,
    typeAndValue,
}: {
    filter: TTrainsFilter;
    typeAndValue: TTrainsFilterTypeAndValue;
}) => {
    const filterManager = getFilterManagerByType(typeAndValue.type);

    // trains "any" type for filterManager + filter
    return filterManager.prepareValueBeforeSaveToState({
        filter: filter,
        value: typeAndValue.value,
    } as any);
};
