import {INearestTrainDatesByDirection} from 'types/trains/search/searchInfo/INearestTrainDates';
import {
    isFilledTrainsSearchContext,
    TrainsSearchContextType,
} from 'reducers/trains/context/types';

import {checkHasNearestTrainDatesByDirection} from './checkHasNearestTrainDatesByDirection';

export const checkHasNearestTrainDatesByContext = ({
    searchContext,
    nearestTrainDatesByDirection,
}: {
    searchContext: TrainsSearchContextType;
    nearestTrainDatesByDirection?: INearestTrainDatesByDirection;
}): boolean => {
    if (!isFilledTrainsSearchContext(searchContext)) {
        return false;
    }

    return checkHasNearestTrainDatesByDirection({
        nearestTrainDatesByDirection,
        direction: searchContext.direction,
        isRoundTrip: Boolean(searchContext.returnWhen),
    });
};
