import {EDirection} from 'types/common/EDirection';
import {
    ENearestTrainDatesReason,
    INearestTrainDatesByDirection,
} from 'types/trains/search/searchInfo/INearestTrainDates';

import {getNearestTrainDatesByDirection} from './getNearestTrainDatesByDirection';

const SUPPORTED_REASONS = [
    ENearestTrainDatesReason.NO_REQUESTED_DATE_TRAINS,
    ENearestTrainDatesReason.NO_REQUESTED_DATE_DIRECT_TRAINS,
];

export const checkHasNearestTrainDatesByDirection = ({
    direction,
    isRoundTrip,
    nearestTrainDatesByDirection,
}: {
    isRoundTrip: boolean;
    direction?: EDirection | null;
    nearestTrainDatesByDirection?: INearestTrainDatesByDirection;
}): boolean => {
    const nearestTrainDates = getNearestTrainDatesByDirection({
        direction,
        nearestTrainDatesByDirection,
    });

    if (!nearestTrainDates || isRoundTrip) {
        return false;
    }

    const {reason, dates} = nearestTrainDates;

    return SUPPORTED_REASONS.includes(reason) && dates?.length > 0;
};
