import {EDirection} from 'types/common/EDirection';
import {
    INearestTrainDatesByDirection,
    INearestTrainDates,
} from 'types/trains/search/searchInfo/INearestTrainDates';

export const getNearestTrainDatesByDirection = ({
    direction,
    nearestTrainDatesByDirection,
}: {
    direction?: EDirection | null;
    nearestTrainDatesByDirection?: INearestTrainDatesByDirection;
}): INearestTrainDates | undefined => {
    if (direction === EDirection.BACKWARD) {
        return nearestTrainDatesByDirection?.backward;
    }

    return nearestTrainDatesByDirection?.forward;
};
