import {TrainsSearchContextType} from 'reducers/trains/context/types';
import {EDirection} from 'types/common/EDirection';

export const checkTrainsHasPinnedSearchSegment = ({
    context,
}: {
    context: TrainsSearchContextType;
}): boolean => {
    if (!context) {
        return false;
    }

    const {direction, forwardSegmentId, backwardSegmentId} = context;

    return (
        (Boolean(forwardSegmentId) && direction === EDirection.BACKWARD) ||
        (Boolean(backwardSegmentId) && direction === EDirection.FORWARD)
    );
};
