import {ITrainsSegment} from 'types/trains/common/segment/ITrainsSegment';
import {ETrainsFeatureType} from 'types/trains/common/features/ETrainsFeatureType';

export interface ITrainsSegmentHighSpeedTrainOptions {
    id: string;
    title: string;
}

export const getTrainsSegmentHighSpeedTrain = (
    segment: ITrainsSegment,
): ITrainsSegmentHighSpeedTrainOptions | undefined => {
    const namedTrainFeature =
        segment.features?.[ETrainsFeatureType.NAMED_TRAIN];

    if (
        !namedTrainFeature ||
        namedTrainFeature.type !== ETrainsFeatureType.NAMED_TRAIN
    ) {
        return undefined;
    }

    if (namedTrainFeature.isHighSpeed) {
        return {
            id: String(namedTrainFeature.id),
            title: namedTrainFeature.title,
        };
    }
};
