import {ITrainsMinTariffClass} from 'types/trains/common/tariffs/ITrainsMinTariffsClass';
import {ETrainsCoachType} from 'types/trains/common/tariffs/ETrainsCoachType';
import {ITrainsMinTariffs} from 'types/trains/common/tariffs/ITrainsMinTariffs';

export const getTrainsSegmentTariffClasses = (
    tariffs?: ITrainsMinTariffs,
): ITrainsMinTariffClass[] => {
    if (!tariffs?.classes) {
        return [];
    }

    return Object.keys(tariffs.classes).reduce<ITrainsMinTariffClass[]>(
        (accumulationTariffList, classType) => {
            const minTariffClass =
                tariffs.classes?.[classType as ETrainsCoachType];

            if (minTariffClass) {
                accumulationTariffList.push(minTariffClass);
            }

            return accumulationTariffList;
        },
        [],
    );
};
