import {ITrainsMinTariffClass} from 'types/trains/common/tariffs/ITrainsMinTariffsClass';

import IPrice from 'utilities/currency/PriceInterface';

import {prepareTrainsTariffPriceValue} from './prepareTrainsTariffPriceValue';

export const calculateTrainsTariffsTotalPrice = (
    tariffs: ITrainsMinTariffClass[],
): IPrice | undefined => {
    const totalPrice: IPrice | undefined = tariffs.reduce<IPrice | undefined>(
        (resultTotalPrice, tariff) => {
            if (resultTotalPrice) {
                return {
                    value: resultTotalPrice.value + tariff.price.value,
                    currency: resultTotalPrice.currency,
                };
            }

            if (tariff.price) {
                return {
                    value: tariff.price.value,
                    currency: tariff.price.currency,
                };
            }

            return undefined;
        },
        undefined,
    );

    if (!totalPrice) {
        return undefined;
    }

    return {
        value: prepareTrainsTariffPriceValue(totalPrice.value),
        currency: totalPrice.currency,
    };
};
