import _isEmpty from 'lodash/isEmpty';

import {
    ITrainsVariant,
    ITrainsVariantAndDirection,
} from 'types/trains/common/variant/ITrainsVariant';
import {ITrainsPriceRangeOption} from 'types/trains/search/filters/ITrainsFilters';
import {ITrainsSegment} from 'types/trains/common/segment/ITrainsSegment';

import {getTrainsVariantSegments} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantSegments';
import {updateTrainsVariantSegments} from 'projects/trains/lib/genericSearch/variants/updateTrainsVariantSegments';
import {updateTrainsSegmentWithTariffsClasses} from 'projects/trains/lib/genericSearch/tariffs/updateTrainsSegmentWithTariffsClasses';
import {getTrainsVariantTariffsClassesByPriceRange} from 'projects/trains/lib/genericSearch/tariffs/getTrainsVariantTariffsClassesByPriceRange';

export const checkAndFilterVariantTariffsByPriceRange = ({
    priceRange,
    variantAndDirection,
}: {
    priceRange: ITrainsPriceRangeOption;
    variantAndDirection: ITrainsVariantAndDirection;
}): ITrainsVariant | null => {
    const variantTariffsClasses = getTrainsVariantTariffsClassesByPriceRange({
        variantAndDirection,
        priceRange,
    });

    if (_isEmpty(variantTariffsClasses)) {
        return null;
    }

    const segments = getTrainsVariantSegments(variantAndDirection);
    const preparedVariantSegments = segments.reduce<ITrainsSegment[] | null>(
        (resultSegments, segment) => {
            if (!resultSegments) {
                return null;
            }

            const segmentTariffClasses = variantTariffsClasses[segment.id];

            if (!segmentTariffClasses) {
                return null;
            }

            const preparedSegment = updateTrainsSegmentWithTariffsClasses({
                segment,
                tariffClasses: segmentTariffClasses,
            });

            resultSegments.push(preparedSegment);

            return resultSegments;
        },
        [],
    );

    if (!preparedVariantSegments) {
        return null;
    }

    return updateTrainsVariantSegments({
        variantAndDirection,
        segments: preparedVariantSegments,
    });
};
