import {ETrainsBrokenClassesCode} from 'types/trains/common/tariffs/ETrainsBrokenClassesCode';

import * as trainsCommonKeyset from 'i18n/trains-common';

export const getSegmentMainTariffTitleByBrokenClassesCode = (
    brokenClassesCode?: ETrainsBrokenClassesCode,
): string | undefined => {
    if (!brokenClassesCode) {
        return;
    }

    switch (brokenClassesCode) {
        case ETrainsBrokenClassesCode.SOLD_OUT: {
            return trainsCommonKeyset.noDashPlaces();
        }

        case ETrainsBrokenClassesCode.OTHER: {
            return trainsCommonKeyset.ticketsDashOffline();
        }

        default: {
            return;
        }
    }
};
