import {ITrainsMinTariffClass} from 'types/trains/common/tariffs/ITrainsMinTariffsClass';
import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import {prepareAndSortTariffListByMaxPrice} from 'projects/trains/lib/genericSearch/tariffs/prepareAndSortTariffListByMaxPrice';
import {getTrainsVariantSegments} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantSegments';

export const getTrainsMaxPriceTariffsByVariant = (
    variantAndDirection: ITrainsVariantAndDirection,
): ITrainsMinTariffClass[] => {
    const variantSegments = getTrainsVariantSegments(variantAndDirection);

    return variantSegments.reduce<ITrainsMinTariffClass[]>(
        (maxPriceTariffs, segment) => {
            const [maxPriceTariff] = prepareAndSortTariffListByMaxPrice(
                segment.tariffs,
            );

            if (maxPriceTariff?.price?.value) {
                maxPriceTariffs.push(maxPriceTariff);
            }

            return maxPriceTariffs;
        },
        [],
    );
};
