import {ITrainsMinTariffClass} from 'types/trains/common/tariffs/ITrainsMinTariffsClass';
import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import {prepareAndSortTariffListByMinPrice} from 'projects/trains/lib/genericSearch/tariffs/prepareAndSortTariffListByMinPrice';
import {getTrainsVariantSegments} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantSegments';

export const getTrainsMinPriceTariffsByVariant = (
    variantAndDirection: ITrainsVariantAndDirection,
): ITrainsMinTariffClass[] => {
    const variantSegments = getTrainsVariantSegments(variantAndDirection);

    return variantSegments.reduce<ITrainsMinTariffClass[]>(
        (minPriceTariffs, segment) => {
            const [minPriceTariff] = prepareAndSortTariffListByMinPrice(
                segment.tariffs,
            );

            if (minPriceTariff?.price?.value) {
                minPriceTariffs.push(minPriceTariff);
            }

            return minPriceTariffs;
        },
        [],
    );
};
