import {TTrainsSegmentId} from 'types/trains/common/segment/ITrainsSegment';
import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';
import {TTrainsMinTariffsClasses} from 'types/trains/common/tariffs/ITrainsMinTariffs';
import {ITrainsPriceRangeOption} from 'types/trains/search/filters/ITrainsFilters';

import {getTrainsVariantSegments} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantSegments';
import {checkHasTrainsVariantTariffClasses} from 'projects/trains/lib/genericSearch/variants/checkHasTrainsVariantTariffClasses';
import {prepareAndSortVariantTariffClassesWithSegmentId} from 'projects/trains/lib/genericSearch/tariffs/prepareAndSortVariantTariffClassesWithSegmentId';
import {prepareTrainsTariffPriceValue} from 'projects/trains/lib/genericSearch/tariffs/prepareTrainsTariffPriceValue';

export const checkTotalPriceValueInPriceRange = ({
    totalPriceValue,
    priceRange,
}: {
    totalPriceValue: number;
    priceRange: ITrainsPriceRangeOption;
}): boolean => {
    return (
        totalPriceValue >= priceRange.min && totalPriceValue <= priceRange.max
    );
};

export const getTrainsVariantTariffsClassesByPriceRange = ({
    priceRange,
    variantAndDirection,
}: {
    priceRange: ITrainsPriceRangeOption;
    variantAndDirection: ITrainsVariantAndDirection;
}): Record<TTrainsSegmentId, TTrainsMinTariffsClasses> => {
    const hasTrainsVariantTariffClasses =
        checkHasTrainsVariantTariffClasses(variantAndDirection);

    if (!hasTrainsVariantTariffClasses) {
        return {};
    }

    const segments = getTrainsVariantSegments(variantAndDirection);
    const tariffClassesWithSegmentId =
        prepareAndSortVariantTariffClassesWithSegmentId(variantAndDirection);

    // Right for segments.length <= 2
    const variantTariffClassesMap: Record<
        TTrainsSegmentId,
        TTrainsMinTariffsClasses
    > = {};

    for (
        let i = 0,
            checkedSegmentIds: TTrainsSegmentId[] = [],
            totalPriceValue = 0;
        i < tariffClassesWithSegmentId.length;
        i++
    ) {
        const firstTariffClassWithSegmentId = tariffClassesWithSegmentId[i];
        const firstTariffClassSegmentId =
            firstTariffClassWithSegmentId.segmentId;
        const firstTariffClass = firstTariffClassWithSegmentId.tariffClass;
        const firstTariffClassPriceValue = prepareTrainsTariffPriceValue(
            firstTariffClass.price.value,
        );

        checkedSegmentIds = [];
        checkedSegmentIds.push(firstTariffClassSegmentId);
        totalPriceValue = firstTariffClassPriceValue;

        if (checkedSegmentIds.length < segments.length) {
            for (let j = i + 1; j < tariffClassesWithSegmentId.length; j++) {
                const secondTariffClassWithSegmentId =
                    tariffClassesWithSegmentId[j];
                const secondTariffClassSegmentId =
                    secondTariffClassWithSegmentId.segmentId;
                const secondTariffClass =
                    secondTariffClassWithSegmentId.tariffClass;

                if (!checkedSegmentIds.includes(secondTariffClassSegmentId)) {
                    checkedSegmentIds.push(secondTariffClassSegmentId);

                    totalPriceValue += prepareTrainsTariffPriceValue(
                        secondTariffClass.price.value,
                    );
                }

                if (checkedSegmentIds.length === segments.length) {
                    const isTotalPriceValueInRange =
                        checkTotalPriceValueInPriceRange({
                            totalPriceValue,
                            priceRange,
                        });

                    if (isTotalPriceValueInRange) {
                        variantTariffClassesMap[firstTariffClassSegmentId] = {
                            ...variantTariffClassesMap[
                                firstTariffClassSegmentId
                            ],
                            [firstTariffClass.type]: firstTariffClass,
                        };

                        variantTariffClassesMap[secondTariffClassSegmentId] = {
                            ...variantTariffClassesMap[
                                secondTariffClassSegmentId
                            ],
                            [secondTariffClass.type]: secondTariffClass,
                        };

                        totalPriceValue = firstTariffClassPriceValue;
                    }
                }
            }
        } else {
            const isTotalPriceValueInRange = checkTotalPriceValueInPriceRange({
                totalPriceValue,
                priceRange,
            });

            if (isTotalPriceValueInRange) {
                variantTariffClassesMap[firstTariffClassSegmentId] = {
                    ...variantTariffClassesMap[firstTariffClassSegmentId],
                    [firstTariffClass.type]: firstTariffClass,
                };
            }
        }
    }

    return variantTariffClassesMap;
};
