import {ITrainsMinTariffClass} from 'types/trains/common/tariffs/ITrainsMinTariffsClass';
import {ITrainsMinTariffs} from 'types/trains/common/tariffs/ITrainsMinTariffs';

import {getTrainsSegmentTariffClasses} from 'projects/trains/lib/genericSearch/segments/getTrainsSegmentTariffClasses';

export const prepareAndSortTariffListByMinPrice = (
    tariffs?: ITrainsMinTariffs,
): ITrainsMinTariffClass[] => {
    const tariffClasses = getTrainsSegmentTariffClasses(tariffs);

    if (!tariffs?.classes) {
        return [];
    }

    return tariffClasses
        .sort((firstTariffClass, secondTariffClass): number => {
            if (
                !firstTariffClass?.price.value ||
                !secondTariffClass?.price.value
            ) {
                return 0;
            }

            return firstTariffClass.price.value - secondTariffClass.price.value;
        })
        .filter(tariffClass => Boolean(tariffClass?.price.value));
};
