import {ITrainsMinTariffClass} from 'types/trains/common/tariffs/ITrainsMinTariffsClass';
import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';
import {
    ITrainsSegment,
    TTrainsSegmentId,
} from 'types/trains/common/segment/ITrainsSegment';

import {getTrainsSegmentTariffClasses} from 'projects/trains/lib/genericSearch/segments/getTrainsSegmentTariffClasses';
import {getTrainsVariantSegments} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantSegments';

export interface ITrainsTariffClassWithSegmentId {
    segmentId: TTrainsSegmentId;
    tariffClass: ITrainsMinTariffClass;
}

const getTrainsTariffClassesWithSegmentIdBySegment = (
    segment: ITrainsSegment,
): ITrainsTariffClassWithSegmentId[] => {
    const segmentTariffClasses = getTrainsSegmentTariffClasses(segment.tariffs);

    return segmentTariffClasses.map(tariffClass => ({
        tariffClass,
        segmentId: segment.id,
    }));
};

const sortTrainsTariffClassesWithSegmentId = (
    firstTariffClassesWithSegmentId: ITrainsTariffClassWithSegmentId,
    secondTariffClassesWithSegmentId: ITrainsTariffClassWithSegmentId,
): number => {
    const firstTariffPriceValue =
        firstTariffClassesWithSegmentId.tariffClass?.price?.value;
    const secondTariffPriceValue =
        secondTariffClassesWithSegmentId.tariffClass?.price?.value;

    if (!firstTariffPriceValue || !secondTariffPriceValue) {
        return 0;
    }

    return firstTariffPriceValue - secondTariffPriceValue;
};

export const prepareAndSortVariantTariffClassesWithSegmentId = (
    variantAndDirection: ITrainsVariantAndDirection,
): ITrainsTariffClassWithSegmentId[] => {
    const segments = getTrainsVariantSegments(variantAndDirection);

    return segments
        .flatMap(getTrainsTariffClassesWithSegmentIdBySegment)
        .sort(sortTrainsTariffClassesWithSegmentId);
};
