import {ITrainsSegment} from 'types/trains/common/segment/ITrainsSegment';
import {TTrainsMinTariffsClasses} from 'types/trains/common/tariffs/ITrainsMinTariffs';

export const updateTrainsSegmentWithTariffsClasses = ({
    segment,
    tariffClasses,
}: {
    segment: ITrainsSegment;
    tariffClasses: TTrainsMinTariffsClasses;
}): ITrainsSegment => {
    return {
        ...segment,
        tariffs: {
            ...segment.tariffs,
            classes: tariffClasses,
        },
    };
};
