import {TTrainsFeatures} from 'types/trains/common/features/TTrainsFeatures';
import {ETrainsFeatureType} from 'types/trains/common/features/ETrainsFeatureType';

export const getTrainNameByFeatures = ({
    features,
    checkSubTypeFeature = true,
}: {
    features: TTrainsFeatures | undefined;
    checkSubTypeFeature?: boolean;
}): string | undefined => {
    const namedTrainFeature = features?.[ETrainsFeatureType.NAMED_TRAIN];
    const hasSubTypeFeature = Boolean(features?.[ETrainsFeatureType.SUBTYPE]);

    if (hasSubTypeFeature && checkSubTypeFeature) {
        return undefined;
    }

    if (namedTrainFeature?.type === ETrainsFeatureType.NAMED_TRAIN) {
        return namedTrainFeature.title;
    }
};
