import {ITrainsTrainRangeArrival} from 'types/trains/common/features/TTrainsFeature';
import {ETrainsFeatureType} from 'types/trains/common/features/ETrainsFeatureType';
import {TTrainsFeatures} from 'types/trains/common/features/TTrainsFeatures';

export const getTrainRangeArrivalByFeatures = (
    features?: TTrainsFeatures,
): ITrainsTrainRangeArrival | undefined => {
    const subsegmentsTrainFeature = features?.[ETrainsFeatureType.SUBSEGMENTS];

    if (subsegmentsTrainFeature?.type === ETrainsFeatureType.SUBSEGMENTS) {
        const {arrival} = subsegmentsTrainFeature;

        if (arrival?.min && arrival?.max) {
            return arrival;
        }
    }

    return undefined;
};
