import moment from 'moment-timezone';

import {ITrainsSegment} from 'types/trains/common/segment/ITrainsSegment';

export const getTrainsTotalDurationBySegments = ({
    firstSegment,
    lastSegment,
}: {
    firstSegment: ITrainsSegment;
    lastSegment: ITrainsSegment;
}): number => {
    return moment(lastSegment.arrival).diff(firstSegment.departure, 'seconds');
};
