import moment from 'moment-timezone';

import {ITrainsSegment} from 'types/trains/common/segment/ITrainsSegment';

export const getTrainsTransferDurationBySegments = ({
    currentSegment,
    nextSegment,
}: {
    currentSegment: ITrainsSegment;
    nextSegment: ITrainsSegment;
}): number => {
    return moment(nextSegment.departure).diff(
        currentSegment.arrival,
        'seconds',
    );
};
